# 지수 탐색

## 알아야 하는 내용

- [이진 탐색](./이진%20탐색.md)

## 문제

n개 원소로 구성된 **정렬된** 배열이 주어졌을 때, 특정 원소의 인덱스를 찾는 함수를 구하라.

## 절차

1. 인덱스를 2배씩 늘려가며 찾고자 하는 원소가 속하는 범위를 찾는다.
2. 만약 찾고자 하는 원소가 속하는 범위를 찾는다면, 해당 범위에서 이진 탐색을 수행한다.
3. 만약 찾고자 하는 원소가 속하는 범위가 없다면 -1을 반환한다.

## 시간 복잡도

- 최악: $O(\log i)$ ($i$는 찾고자 하는 원소의 인덱스)
- 최선: $O(1)$

$i$가 찾고자 하는 원소의 인덱스라고 할 때, 탐색을 $\lceil \log i \rceil$번 수행하기 때문에 찾고자 하는 원소가 속하는 범위를 찾는 과정의 복잡도는 $O(\log i)$이다.

이진 탐색을 수행하는 과정의 복잡도는 이진 탐색의 복잡도와 동일하게 $O(\log i)$이다. (참고: [이진 탐색](./이진%20탐색.md))

그러므로, 지수 탐색의 복잡도는 다음과 같이 쓸 수 있다.

$O(\log i) + O(\log i) = 2O(\log i) = O(\log i)$

## 예시

```
arr = [1, 2, 3, 4, 5, 6, 7, ... 998, 999, 1000]
target = 998

1. 찾고자 하는 원소가 속하는 범위 탐색
    arr[1]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[2]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[4]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[8]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[16]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[32]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[64]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[128]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[256]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[512]이 998보다 작으므로 인덱스를 2배 늘린다.
    arr[1024]가 존재하지 않으므로 512 이상의 범위에 대해 이진 탐색을 수행한다.

2. 이진 탐색
```

## 이진 탐색과의 비교

논의의 편의를 위해 덜 이론적인 예시를 살펴보자. 1,000,000개 원소로 이루어진 배열에서 4번째에 위치한 원소를 찾는다고 할 때,

- 이진 탐색은 배열의 중간부터 시작하여 많은 반복문을 지나야 4번째 원소에 도착한다.
- 지수 탐색은 2번 만에 4번째 원소에 도착한다.

## 구현

- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/search/exponential_search.cpp)
- [JavaScript](https://github.com/TheAlgorithms/Javascript/blob/master/Search/ExponentialSearch.js)
